
CREATE TABLE BADGE
(
    idbadge INTEGER,
    idpersonne_badge INTEGER,
    CONSTRAINT BADGE_PK PRIMARY KEY(idbadge),
    CONSTRAINT FK_BADGE_PERSONNE_ID FOREIGN KEY(idpersonne_badge) REFERENCES PERSONNES(IDPERSONNE) ON DELETE CASCADE
);
 
  CREATE TABLE LIEUX
(
    emplacement VARCHAR(100),
    horaire_ouverture TIMESTAMP,
    horaire_fermerture TIMESTAMP,
    CONSTRAINT LIEUX_PK PRIMARY KEY(emplacement)
);
 
  CREATE TABLE ADMINISTRATEUR
(
    idadmin INTEGER,
    motdepasse   VARCHAR2(100),
    CONSTRAINT PK_ADMINISTRATEUR PRIMARY KEY(idadmin)
);

   CREATE TABLE PERSONNES
(
    idpersonne INTEGER,
    nom   VARCHAR2(100),
    prenom VARCHAR(100),
    date_de_naissance VARCHAR(100),
    fonction VARCHAR(100),
    CONSTRAINT PK_PERSONNE PRIMARY KEY(idpersonne)
);
 
CREATE TABLE profil 
(   idprofil NUMBER(2),
    titre_profil VARCHAR2(10),
    profil_openh TIMESTAMP,
    profil_closeh TIMESTAMP,
    profil_idlieux INTEGER,
    CONSTRAINT PK_PROFIL PRIMARY KEY(idprofil),
    CONSTRAINT FK_place_idlieux FOREIGN KEY(profil_idlieux) REFERENCES LIEUX(IDLIEUX)
)


CREATE SEQUENCE lieux_sequence
  START WITH     1
  INCREMENT BY   1
  NOCACHE
  NOCYCLE;
  
CREATE SEQUENCE badges_sequence
  START WITH     1
  INCREMENT BY   1
  NOCACHE
  NOCYCLE;
  
CREATE SEQUENCE administrateur_sequence
  START WITH     1
  INCREMENT BY   1
  NOCACHE
  NOCYCLE;
  
CREATE SEQUENCE personnes_sequence
  START WITH     1
  INCREMENT BY   1
  NOCACHE
  NOCYCLE;
  
CREATE SEQUENCE profil_sequence
  START WITH     1
  INCREMENT BY   1
  NOCACHE
  NOCYCLE;